module.exports = function(grunt) {

	grunt.config('htmlmin', {
		dist: {
			options: {
				collapseWhitespace: true,
				collapseBooleanAttributes: true,
				removeCommentsFromCDATA: true,
				removeOptionalTags: true,
				processScripts: ["text/ng-template", "text/x-handlebars-template"]
			},
			files: [{
				expand: true,
				cwd: '<%= yeoman.app %>',
				src: ['src/accessibledatepicker/*.html', '!index*.html'],
				dest: '<%= yeoman.dist %>'
			},
			{	
				expand: true,
				cwd: '<%= yeoman.dist %>',
				src: ['index*.html'],
				dest: '<%= yeoman.dist %>'
			}]
		}
	});

	grunt.loadNpmTasks('grunt-contrib-htmlmin');

};
